<?php
namespace PrestaShop\Module\LCVPrestaConnector\Models;

/**
 * Objet d'interface contenant la définition d'un détail de commande
 */
class OrderDetail extends SanitizedObject
{
    /**
     * Référence du fournisseur
     */
    public string $product_supplier_reference = "";

    /**
     * EAN13
     */
    public string $product_ean13 = "";

    /**
     * Quantité commandée
     */
    public int $product_quantity = 0;

    /**
     * Nom du produit
     */
    public string $product_name = "";

    /**
     * Prix total TTC
     */
    public float $total_price_tax_incl = 0;    

    /**
     * Prix unitaire HT
     */
    public float $unit_price_tax_excl = 0;

    /**
     * Prix original du produit
     */
    public float $original_product_price = 0;

    /**
     * Montant total remboursé !
     */
    public float $total_refund = 0;

    /**
     * Taux de TVA
     */
    public float $tax_rate = 0;

    /**
     * Nettoyage
     */
    public function sanitize()
    {
    }
}