<?php

use PrestaShop\Module\LCVPrestaConnector\BridgeAdapter;
use PrestaShop\Module\LCVPrestaConnector\SyncConfiguration;

/**
 * Boucle principale de synchronisation 
 * 
 * Pour éxécuter les tâches asynchrones, il faudra appeler ce contrôleur via tâches automatisées le plus fréquemment
 * possible.
 */

class LCVPrestaConnectorCronModuleFrontController extends \ModuleFrontController
{
    /**
     * Page de maintenance ?
     * 
     */
    protected function displayMaintenancePage()
    {
        // Pas de maintenance pour ce contrôleur !
    }

   /**
    * Appel ici
    */
   public function display()
    {
        // Quoiqu'il arrive, on renvoi une réponse de type texte, utf8 !
        header('Content-Type: text/plain; charset=utf-8');        

        // Est-ce le bon token ?        
        $module = $this->module;

        // Module est un \PrestraConnector, on le signale en PHPdoc pour avoir l'autocomplétion
        /** @var PrestaShop\Module\LCVPrestaConnector\LCVPrestaConnector $module */
               
        $token_to_have = $module->getCfg()->get(SyncConfiguration::CFG_GUARD_TOKEN);
        if (Tools::getValue('guard') != $token_to_have)
        {           
            // Code réponse 403
            http_response_code(403); 
            echo 'Token de sécurité incorrect';
            return;
        }

        // Fin de la session pour éviter de bloquer le processus et les autres demandes du même utilisateur
        if (session_id()) 
            session_write_close();

        // Appel de la synchronisation (aucun code ici)
        $syncer = new PrestaShop\Module\LCVPrestaConnector\Syncer($this->module, true);

        // Si on a passé le paramètre full à 1 dans l'URL alors on résynchronise tout
        try
        {
            $syncer->sync(Tools::getValue('full') == 1);
        }
        catch (\Exception $e)
        {
            // On affiche l'erreur
            http_response_code(500);
            // L'erreur est dans l'audit qui est affichée automatiquement à la fin de l'appel à ce contrôleur (ob_stream)
        }
    }
}