<?php
namespace PrestaShop\Module\LCVPrestaConnector\Models;

use DateTime;

/**
 * Objet d'interface contenant la définition d'un bon (cadeaux, avoir, ...)
 */
class Voucher extends SanitizedObject
{
    /**
     * Bon cadeau
     */
    public const GIFT_VOUCHER = 1;
    /**
     * Avoir
     */
    public const AVOIR_VOUCHER = 2;

    /**
     * Identifiant du bon (code)
     * 
     * @param string Code du bon
     */    
    public string $code;
    
    /**
     * Montant de réduction TTC
     */
    public float $amountTTC = 0;

    /**
     * Pourcentage de réduction du montant total
     */
    public float $reduction = 0;

    /**
     * Quantité de bons encore disponibles !
     */
    public int $quantity = 1;

    /**
     * Pas valide avant le
     */
    public ?DateTime $startDate = null;

    /**
     * Date d'expiration
     */
    public ?DateTime $expirationDate = null;

    /**
     * Montant minimum pour que le bon soit valide
     */
    public float $minimumAmount = 0;

    /**
     * Nom du bon
     */
    public string $name = "";

    /**
     * Réservé à l'id client
     */
    public int $customer_id = 0;

    /**
     * Type de bon
     * 
     * 0: inconnu/non géré
     * 1: GIFT_VOUCHER
     * 2: AVOIR_VOUCHER
     */
    public int $type = 0;

    /**
     * Disponible
     */
    public bool $active = true;

    /**
     * Ce bon doit être ignoré !
     */
    public bool $ignore = false;
    
    /**
     * Nouveau bon
     * 
     * @param string Code du bon
     * @param float Montant de réduction TTC
     * @param float Pourcentage de réduction du montant total
     */
    public function __construct(
        string $code,
        float $amount,
        float $reduction
        )
    {
        // Sanitize
        $this->code = $this->sanitizeStr($code, 32);
        $this->amountTTC = $amount;
        $this->reduction = $reduction;
    }

    /**
     * Nettoyage de la donnée sur les standards Prestashop
     */
    public function sanitize()
    {
        $this->code = $this->sanitizeStr($this->code, 32);
        if (!isset($this->name) || empty($this->name))
            $this->name = sprintf("Bon #%s", $this->code);
    }
}