<?php
namespace PrestaShop\Module\LCVPrestaConnector\Models;

use DateTime;

/**
 * Objet d'interface contenant la définition d'une commande
 */
class Order extends SanitizedObject
{
    /**
     * Identifiant de la commande
     */
    public string $reference;

    /**
     * Tag d'idempotence
     */
    public string $tag;

    /**
     * Révision de la commande
     */
    public int $revision = 0;

    /**
     * Date de la commande
     */
    public string|null $date = null;

    /**
     * Identifiant du client
     */
    public int|null $id_customer = null;

    /**
     * Identifiants des commandes Prestashop inclue dans cette commande
     * 
     * @param array<int> $id_orders Identifiants des commandes Prestashop
     */
    public array $id_orders = [];

    /**
     * Détails des produits
     * 
     * @param array<OrderDetail> $details Détails des produits
     */
    public array $details = [];

    /**
     * Paiements
     * 
     * @param array<OrderPayment> $payments Paiements
     */
    public array $payments = [];

    /**
     * Voucher utilisés
     * 
     * @param array<OrderVoucher> $vouchers Vouchers
     */
    public array $vouchers = [];

    /**
     * Nettoyage de la commande
     */
    public function sanitize()
    {        
        // On nettoie les détails des produits
        foreach ($this->details as $detail)
            $detail->sanitize();

        // On nettoie les paiements
        foreach ($this->payments as $payment)
            $payment->sanitize();

        // On nettoie les vouchers
        foreach ($this->vouchers as $voucher)
            $voucher->sanitize();
    }
}