<?php
namespace PrestaShop\Module\LCVPrestaConnector\Models;

/**
 * Objet d'interface contenant la définition d'un article (taille)
 */
abstract class SanitizedObject
{
    protected static $invalidChars = '<>;={}';
    
    /**
     * Sanitize a string
     * Remove from value all characters which are not present in validRegex, replacing them by a '_' and
     * if value is longer than maxLen, truncate it
     * work in UTF8
     * 
     */
    protected function sanitizeStr(?string $value, int $maxLen, string $invalidChars = '') : string|null
    {
        if (!$value)
            return $value;

        if (!$invalidChars)
            $invalidChars = self::$invalidChars;

        $value = mb_eregi_replace('/['.$invalidChars.']/', '_', $value);
        if (strlen($value) > $maxLen)
            $value = mb_strimwidth($value, 0, $maxLen);

        $value = trim($value);
        if (empty($value))
            $value = null;

        return $value;
    }

    /**
     * Nettoyage de la donnée sur les standards Prestashop
     */
    public abstract function sanitize();
}