<?php
namespace PrestaShop\Module\LCVPrestaConnector\Models;

/**
 * Objet d'interface contenant la définition du stock d'un produit
 */
class Stock extends SanitizedObject
{
    /**
     * Identifiants du produit sous le backoffice
     * 
     * @param array<string> Références
     */    
    public array $refs;

    /**
     * EAN fournisseurs
     * 
     * @param array<string> Références
     */    
    public ?array $eans = null;

    /**
     * Quantité en stock, par code magasin
     * 
     * @var array<string, int>
     */
    public array $qties = [];

    /**
     * Prix de vente
     */
    public ?float $prixTTC = null;

    /*
     * Id produit résolu
     */
    public ?int $id_product = null;
    
    /**
     * Nouveau stock
     * 
     * @param array<string> $refs code barres de la référence
     * @param array<string, int> $qties Quantité
     */
    public function __construct(
        array $refs,
        array $qties
        )
    {
        // Sanitize
        $this->refs = $refs;
        $this->qties = $qties;
    }

    /**
     * Détermine si le stock est une référence générique.
     * Dans ce cas, il faudra considérer que toutes les références du produit sont sans stock.
     */
    public function isWildcard()
    {
        return (count($this->refs) == 1 && substr($this->refs[0], -1) == "*");
    }

    /**
     * Nettoyage de la donnée sur les standards Prestashop
     */
    public function sanitize()
    {
        if ($this->eans)
            for ($i = 0; $i < count($this->eans); $i++)
                $this->eans[$i] = $this->sanitizeStr($this->eans[$i], 32);
    }
}