<?php

namespace PrestaShop\Module\LCVPrestaConnector\Forms;

use PrestaShop\Module\LCVPrestaConnector\SyncConfiguration;
use PrestaShopBundle\Form\Admin\Type\CustomContentType;
use Symfony\Component\Form\FormBuilderInterface;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class OrderType extends ConnectorType {
    

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $cfg = $this->module->getCfg();
        $backofficeName = $this->module->getBridge()->getId();
        $supportedOptionalFeatures = $this->module->getBridge()->getSupportedOptionalFeatures();

        /**
         * Commandes
         */
        $builder->add('title_orders', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => false,
                'title' => 'Exportation des commandes',
            ],
        ]);

        $builder
            ->add(SyncConfiguration::CFG_ORDER_BARRIER, TextType::class, [
                'label' => 'ID minimal d\'exportation',
                'help' => 'Seules les commandes ayant un ID strictement supérieur à cette valeur seront exportées vers '.$backofficeName.'.',
                'required' => false,
                'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_ORDER_BARRIER),
            ]);

        $builder
            ->add(SyncConfiguration::CFG_ORDER_MAX_TIME, TextType::class, [
                'label' => 'Age maximal d\'exportation',
                'help' => 'Indiquez le nombre de jours pendant lesquels une commande peut être exportée vers '.$backofficeName.' après sa création.',
                'required' => false,
                'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_ORDER_MAX_TIME),
            ]);

        $builder->add(SyncConfiguration::CFG_ORDER_EXPORT_REFUND, SwitchType::class, [
            'label' => 'Exporter les annulations, modifications, remboursements et retours',
            //'help' => $optionsDesc[$field]['description'],  // Utilisation de la description pour l'aide                
            'required' => false,
            'data' => $cfg->get(SyncConfiguration::CFG_ORDER_EXPORT_REFUND) ?? false, // valeur par défaut selon l'option configurée
        ]);

        /**
         * Clients
         */
        $builder->add('title_customers', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => true,
                'title' => 'Synchronisation des clients',
            ],
        ]);

        if (in_array(SyncConfiguration::CFG_IMPORT_CUSTOMERS, $supportedOptionalFeatures))
            $builder->add('customer_import', SwitchType::class, [
                'label' => 'Importer les clients depuis '.$backofficeName,
                //'help' => $optionsDesc[$field]['description'],  // Utilisation de la description pour l'aide                
                'required' => false,
                'data' => $cfg->get(SyncConfiguration::CFG_IMPORT_CUSTOMERS) ?? false, // valeur par défaut selon l'option configurée
            ]);

        $builder->add('customer_export', SwitchType::class, [
            'label' => 'Exporter les clients vers '.$backofficeName,
            'help' => 'Seuls les clients hors marketplace qui ont effectué au moins une commande validée sont synchronisés avec '.$backofficeName,
            'required' => false,
            'data' => $cfg->get(SyncConfiguration::CFG_EXPORT_CUSTOMERS) ?? false, // valeur par défaut selon l'option configurée
        ]);

        /**
         * Frais de port
         */
        $builder->add('title_ref_sw', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => true,
                'title' => 'Références de frais de port',
                'help' => '<p>Indiquez ci-dessous les références des produits utilisés pour facturer les frais de port et les frais d\'emballage dans votre backoffice.</p>',
            ],
        ]);
        
        $builder
            ->add('shipping_ref', TextType::class, [
                'label' => 'Référence pour les frais de port',                
                'required' => false,
                'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_SHIPPING_COST_REF),
            ]);

        $builder
            ->add('wrapping_ref', TextType::class, [
                'label' => 'Référence pour l\'emballage',                
                'required' => false,
                'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_WRAPPING_COST_REF),
            ]);

        /**
         * Mappage des modes de règlements
         */
        $builder->add('title_map_reg', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => true,
                'title' => 'Mapping des modes de règlements',
                'help' => '<p>Les règlements ci-dessous ont été autodétecté et correspondent à des modes de règlements utilisés pour payer des commandes à importer.<br>
                            Pour chaque règlement, indiquer quel code de règlement utilisé pour importer le paiement sous votre backoffice.</p>',
            ],
        ]);

        // On va préablement récupérer le mapping existant
        $mapReg = $cfg->get(SyncConfiguration::CFG_ORDER_PAY_MAPPAGE) ?? [ "*" => "" ];

        // Puis, nous allons créer une option pour chaque mode de règlement, de type text
        foreach ($mapReg as $key => $value) {
            $hint = null;
            if ($key == '*')
                $hint = 'Utilisez ce champ pour indiquer quel mode de règlement utiliser quand aucun autre ne correspond.';

            // On encode la clé avec base64 sans = pour éviter les problèmes de clé
            $safe_key = 'map_reg_'.rtrim(base64_encode($key), '=');

            $builder->add($safe_key, TextType::class, [
                'label' => $key,
                'help' => $hint,
                'required' => false,
                'data' => $value,
            ]);
        }

        // On propose la configuration des importations de bons
        $vouchersSupported = $cfg->describeVoucherConfiguration();
        if (count($vouchersSupported) > 0)
        {
            $builder->add('title_import_voucher', CustomContentType::class, [
                'label' => false,
                'template' => $this->titleFormTemplatePath,
                'data' => [
                    'hr' => true,
                    'title' => 'Type des bons importés',
                    'help' => '<p>Sélectionnez dans la liste ci-dessous les types de bons que le module importera sous Prestashop.</p>',
                ],
            ]);
            
            $voucher = $cfg->get(SyncConfiguration::CFG_VOUCHER_IMPORT_TYPES);
            foreach ($vouchersSupported as $k => $p)
            {
                $builder->add('import_voucher_'.$k, SwitchType::class, [
                    'label' => $p['label'],
                    //'help' => $optionsDesc[$field]['description'],  // Utilisation de la description pour l'aide                
                    'required' => false,
                    'data' => isset($voucher[$k]) ? $voucher[$k] : false, // valeur par défaut selon l'option configurée
                ]);
            }
        }

        // Bouton de sauvegarde
        $builder->add('Enregistrer', SubmitType::class, [
            'attr' => ['class' => 'btn-form-valid btn-primary']
        ]);
    }
}