<?php
namespace PrestaShop\Module\LCVPrestaConnector\Forms;

use PrestaShopBundle\Form\Admin\Type\ButtonCollectionType;
use PrestaShopBundle\Form\Admin\Type\CustomContentType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;

class ConfirmDialogType extends ConnectorType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {   
        // Obtenir les données du form passé dans le createForm
        $data = $options['data'];
        $title = $options['data']['title'] ?? 'Demande de confirmation';        
        $txt = $options['data']['txt'] ?? 'Confirmez-vous votre action ?';        
        $yes = $options['data']['yes'] ?? 'Oui, continuer';
        $no = $options['data']['no'] ?? 'Annuler';
        $cancel = $options['data']['cancel'] ?? '';
        
        $builder->add('title', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => false,
                'title' => $title,
                'help' => $txt,
            ],
        ]);
        
        $builder->add('actions', ButtonCollectionType::class, [
            'required' => false,
            'buttons' => [
                'no' => [
                    'type' => ButtonType::class,
                    'options' => [                        
                        'label' => $no,
                        'attr' => [
                            'class' => 'btn-form-valid btn-outline-secondary',
                            'onclick' => 'window.location.href="'.$cancel.'"'
                        ]
                    ]
                ],
                'submit' => [
                    'type' => SubmitType::class,
                    'options' => [
                        'label' => $yes,
                        'attr' => ['class' => 'btn-form-valid btn-primary']
                    ]
                ],            
            ],
            'attr' => [
                'class' => 'prestaconnector-row-actions',
            ],        
        ]);
    }

}