<?php

namespace PrestaShop\Module\LCVPrestaConnector\Controller;

use PrestaShop\Module\LCVPrestaConnector\SyncConfiguration;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use PrestaShop\Module\LCVPrestaConnector\Syncer;

class CronAdminController extends AdminController
{
    /**
     * Disable authentication for cron tasks
     */
    protected function isAuthenticationRequired(): bool
    {
        return false;
    }

    /**
     * Point d'entrée de la tâche CRON
     * Cron action
     * 
     * @return JsonResponse
     */
    public function cronAction(Request $request)
    {
        /** @var PrestaShop\Module\LCVPrestaConnector\LCVPrestaConnector $module */
        $module = $this->module;

        // Module est un \PrestraConnector, on le signale en PHPdoc pour avoir l'autocomplétion        
        $token_to_have = $module->getCfg()->get(SyncConfiguration::CFG_GUARD_TOKEN);
        if ($request->query->get('guard') != $token_to_have)
            return new JsonResponse(['success' => false, 'message' => 'Token de sécurité incorrect'], 403);
        
        // Fin de la session pour éviter de bloquer le processus et les autres demandes du même utilisateur
        if (session_id())
            session_write_close();

        // Appel de la synchronisation (aucun code ici)
        $syncer = new Syncer($this->module, true);

        // Si on a passé le paramètre full à 1 dans l'URL alors on résynchronise tout
        $logs = null;
        $reason = null;
        try
        {
            // All the logs go to the symfony log system
            ob_start();

            $reason = $syncer->sync($request->query->get('full') == 1);            

            if ($request->query->get('details') == 1) $logs = ob_get_clean(); else ob_get_clean();
        }
        catch (\Exception $e)
        {
            // On affiche l'erreur
            if ($request->query->get('details') == 1) $logs = ob_get_clean(); else ob_get_clean();

            return new JsonResponse(['success' => false, 'message' => $e->getMessage()], 500);            
        }
        
        $success = $reason === null;
        $errCode = $reason ?? 'OK';
        $msg = '';
        switch ($reason ?? '') {
            case '':
                $msg = "Synchronization completed successfully.";
                break;
            case 'ALREADY_RUNNING':
                $msg = "Synchronization could not be started because another synchronization is already running.";
                break;
            case 'DISABLED':
                $msg = "Synchronization is disabled in the configuration.";
                break;
            default:
                $msg = "Synchronisation could not be started with unknown reason : " . $reason;
                break;
        }

        if (!$logs)
            $logs = "Logs disabled. Pass 'details=1' to get detailed logs.";

        return new JsonResponse(['success' => $success, 'errCode' => $errCode, 'message' => $msg, 'logs' => $logs]);
    }
}