<?php 
namespace PrestaShop\Module\LCVPrestaConnector\Controller;

use LCVPrestaConnector;
use PrestaShop\Module\LCVPrestaConnector\SyncConfiguration;


/**
 * Tous les contrôleurs admin du module doivent dériver de cette classe 
 * qui expose un certain nombre de fonctions et de propriétés communes essentielles.
 */
abstract class AdminController extends BaseAdminController
{   
    /**
     * lien vers le module
     */
    protected LCVPrestaConnector $module;

    /**
     * Indique si la resynchronisation est en cours
     */
    private ?bool $isResyncing = null;

    /**
     * Initialisation
     */
    public function  __construct() {
        $this->module = \Module::getInstanceByName(strtolower('LCVPrestaConnector'));
        
        // DbUpgrade ?
        $this->module->dbUpgrade();

        // On vérifie s'il faut remonter les hooks
        if (isset($_REQUEST["remount_hook"]))
			$this->module->registerHooks();
    }

    /**
     * Obtient la description de la barre d'outils de l'interface d'administration
     */
    protected function getAdminLayoutToolBar() : array 
    {
        $toolbar = [                
                'resync' => [
                    'href' => '#',
                    'class' => 'btn-outline-primary pc-toolbar-button',
                    'desc' => 'Resynchroniser',
                    'help' => 'Programme une synchronisation totale la prochaine fois que la tâche de synchronisation est lancée.',
                    'icon' => 'refresh',                    
                    'js' => $this->module->name . '_resyncAll();',
                ],
                'pullenv' => [
                    'href' => '#',
                    'class' => 'btn-outline-primary pc-toolbar-button',
                    'desc' => '',
                    'help' => 'Télécharge la configuration du backoffice '.$this->module->getBridge()->getId().'.',
                    'icon' => 'download',
                    'js' => $this->module->name . '_pullenv();',
                ],
                'run' => [
                    'href' => '#',
                    'class' => 'btn-outline-primary pc-toolbar-button',
                    'desc' => '',
                    'help' => 'Déclenche la tâche des synchronisation des données.',
                    'icon' => 'play_circle',
                    'js' => $this->module->name . '_run(\'' . $this->module->getCfg()->get(SyncConfiguration::CFG_GUARD_TOKEN) . '\');',
                ],
            ];
                
        if ($this->isResyncing === null)
        {
            // Extraction de la position de synchronisation
            $positions = $this->module->getCfg()->get(SyncConfiguration::CFG_SYNC_POSITIONS);
            $this->isResyncing = empty($positions);
        }

        if ($this->isResyncing)
        {
            $toolbar['resync']['desc'] = 'Resynchro. demandée !';
            $toolbar['resync']['class'] = 'btn-outline-secondary disabled';
        }

        return $toolbar;
    }

    /**
     * Retourne les variables passées en paramètre enrichies des variables par défaut
     * 
     * @param array $vars Les variables à enrichir
     */
    protected function addDefaultVars(array $vars) : array
    {
        $vars['module_name'] = $this->module->name;

        if (!isset($vars['layoutHeaderToolbarBtn']))
            $vars['layoutHeaderToolbarBtn'] = $this->getAdminLayoutToolBar();

        if (!isset($vars['backoffice']))
            $vars['backoffice'] = $this->module->getBridge()->getId();
        
        return $vars;
    }    
}