---
title: "LCVPrestaConnector - Manuel d'utilisation"
header-left: "LCVPrestaConnector - Manuel d'utilisation"
footer-center: "[page]"
pdf-engine: wkhtmltopdf
...

# Manuel de configuration

La section suivante précise comment installer et configurer le module `LcvPrestaConnector` avec votre backoffice LCV.

*Pour connaître les possibilités du module, savoir si une donnée est synchronisée ou non, et dans quel sens, vous devez vous reporter au manuel technique.*

## Support

Pour obtenir du support sur ce module, merci de joindre le service technique LCV usuel.


## Installation

### Association

Pour fonctionner, le module a besoin de se connecter aux API fournies par votre backoffice. L'association est le processus qui vous permet d'établir cette connexion.

Pour associer votre module, allez dans sa page de configuration accessible depuis l'écran de gestion des modules.

Si le module n'a jamais été associé ou détecte des identifiants périmés, alors il vous proposera automatiquement de procéder à une association avant de continuer avec la configuration du module ; autrement, si vous désirez procéder à une association manuelle, cliquez sur le bouton `désassocier`.

Pour associer votre module à votre installation LCV, vous allez devoir effectuer les étapes suivantes :

1. **entrer l'URL de connexion à votre backoffice.** Il s'agit généralement de l'adresse IP publique (accessible depuis Internet) sur laquelle le service LCV est joignable ; si vous ne connaissez pas cette information, prenez contact avec le support technique de LCV ;
2. **si le certificat de sécurité que vous utilisez est auto-signé,** auto-généré ou invalide, un écran vous demandera de valider son empreinte afin d'être sûr que vous vous connectez au bon endroit ; 
3. **renseignez ensuite le nom d'utilisateur et le mot de passe** qui vous ont été remis par LCV ;



### Mise en place de la tâche automatisée

Le module est conçu pour se connecter au backoffice LCV via une tâche automatisée qui appelle une URL spécifique sur le serveur. 

Il est donc nécessaire de mettre en place sur votre serveur un script qui appelle cette page à intervalles réguliers relativement courts, en général, toutes les 5 minutes.

Cette URL est protégée par un jeton d'accès afin de ne pas permettre à n'importe qui d'exécuter la synchronisation sur votre système. Consultez la page de configuration du module pour connaître l'URL exacte de la page à appeler.

D'une manière générale, si vous utilisez ``crontab`` *(linux)* pour mettre en place votre appel avec curl, l'appel devrait ressembler à ceci :

```bash
*/5 * * * * /usr/bin/curl -k --silent --output /dev/null https://monsite.com/module/lcvprestaconnector/cron?guard=XXXX
```


### Bonnes pratiques

Pour mener vos tests et notamment lors d'un premier raccordement avec votre backoffice, nous vous conseillons de procéder à vos tests sur un site de préproduction.

Avant de tenter chaque changement sur un site de production, pensez à sauvegarder et conserver une sauvegarde complète de votre base de données !

De même, sélectionnez les produits à publier sur le site Internet de manière raisonnée en commençant par une ou deux références présentant des caractéristiques distinctes afin de pouvoir mesurer l'impact du choix de vos options. Avec peu de références, vous pourrez ajuster/supprimer et faire autant d'essais que vous le souhaitez jusqu'à trouver une configuration qui correspond à votre méthode de travail.

Enfin, prenez garde à peut-être désactiver l'exportation des clients si vous ne désirez pas polluer votre backoffice de clients de tests.



### Actions de maintenance

Les actions de maintenance sont présentes sous forme de bouton dans le bandeau supérieure des pages de configuration.

- Demande de resynchronisation : cette option vous permet de dire au module d'effectuer une synchronisation totale lors de sa prochaine connexion. Il retéléchargera toutes vos données depuis le départ.
- **Télécharger la configuration** : cette option demande au module de télécharger tous les paramètres positionnés sur votre backoffice (tables, magasins internet, ...).
- Déclencher la tâche : cet utilitaire déclenche la tâche automatisée de synchronisation.
- **Mappings** : lorsque ce bouton est affiché, il vous permet de définir les mappages des catégories et autres données.
- **Déconnecter** : ce bouton vous permet de vous dissocier du backoffice pour effectuer un nouveau jumelage.



### Configuration générale

#### Options globales

* **Synchronisation activée :** le module vous permet d'activer ou de désactiver rapidement la synchronisation des données, afin, par exemple, de mettre en pause l'opération. Désactiver la synchronisation empêche toute communication entre le site et le backoffice LCV, dans un sens, comme dans l'autre.
* **Mode de synchronisation :** il existe deux modes de synchronisation. Le mode basique importe seulement les stocks, les prix et les promotions alors que le mode complet créée et entretien les fiches produits : référence, nom, description, photos et classification. Consultez la documentation technique pour connaître la liste exhaustive des données entretenues dans chacun des deux modes. Quelque soit le mode, les données exportées (commandes, clients, ...) sont toujours les mêmes.
* **Intervalles de synchronisation :** vous pouvez choisir ici à quelle fréquence vos informations sont mises à jour. Plus la fréquence est élevée et plus la puissance de traitement nécessaire est grande. *Notez que quelques soient les valeurs indiquées ici, les synchronisations n'interviennent que lors de l'appel à la tâche CRON ; aussi les fréquences ne peuvent être plus basses que celle de l'appel à la tâche.*

#### Paramètre du stock

* l'option **stock de sécurité** vous permet de soustraire une ou plusieurs pièces en stock de chaque taille afin d'être sûr de ne jamais être hors stock sur votre site : il s'agit d'un montant qui sera déduit du stock. Par exemple, si vous mettez "1" et que vous avez 4 pièces en stock sur la taille L, le site Internet pensera que vous n'en avez que 3.
* l'option **visibilité des produits en stock** vous permet de choisir s'il faut afficher les produits dans le catalogue ou les recherches lorsque ce dernier n'a plus de stock ; ou bien s'il vaut mieux cacher le produit. Un produit caché est toujours accessible via son URL pour ne pas nuire à votre référencement Internet.
* l'option **Composition du stock en ligne** vous permet de déterminer quels sont les magasins qui mettent leur stock à disposition pour les ventes en ligne. Si aucun n'est coché, le module considère que tous les magasins participent.

#### Paramètre du catalogue

* les options **Fonctionnalités de catalogue** vous permettent d'activer le sélecteur de produits connexes ou d'afficher la disponibilité de vos pièces en magasin (même si un magasin ne participe pas au stock de vente en ligne et le stock minimal n'influe pas sur la quantité présentée ici).
* l'option **attributs discrimants** vous permet de choisir de créer un produit Prestashop pour chaque produit LCV ou bien plutôt un produit Prestashop pour chaque couleur, ou matière différente. Sélectionnez alors les attributs qui sont discriminants d'un produit unique. Dans le doute, laissez tout décoché (cf. Manuel technique).
* l'option **mappage des attributs de produit** vous permet de faire correspondre chaque attribut LCV à un groupe d'attributs Prestashop. Les attributs à l'intérieur de ce groupe sont créés automatiquement selon la nécessité. *Par exemple, vous sélectionnez "coloris" pour la couleur, le module créera chaque couleur : rouge, bleu, ...*
  Notez que si vous n'affectez pas de groupe d'attributs Prestashop en face d'un attribut LCV, alors cette information ne sera pas synchronisée.
* l'option **mappage des caractéristiques de produit** est la même chose que l'option précédente, mais pour les caractéristiques des produits et non les groupes d'attributs.
* l'option **mappage des couleurs** vous permet de sélectionner un groupe d'attributs Prestashop pour lequel un filtre de correspondance vous permet de remplacer la couleur fournie par une couleur générique correspondante afin de limiter le nombre de couleurs présentées sur le site à une liste correcte pour les filtres.
  *Par exemple, vous pourrez définir que "moutarde", "paille", "or" et "doré" correspondent toutes à la couleur "jaune".*
  Le module est fourni avec une liste d'équivalence de couleurs en couleurs génériques (noir, blanc, beige, gris, bleu, rouge, orange, marron, vert, jaune, violet et rose) et lorsque le module détecte plusieurs couleurs (i.e. noir&blanc ou noir/blanc), il positionne une couleur nommée "multicolore".
  Vous pouvez compléter cette liste par des équivalences de votre choix dans la section `Catalogue` > `Mappages LCV`.
* l'option **mappage des réductions** vous permet de classer les produits concernés par une promotion dans une catégorie spécifique de Prestashop. Cette option est utile quand vous désirez présenter une page spéciale pour un évènement spécial, du type semaine du *Black Friday*. Les promotions sont automatiquement ajoutés ou retirés de cette liste lorsque le module en découvre l'existence lors de la synchronisation.
* les **options d'importation de produits** vous permettent de choisir quelles sont les données mises à jour lors de la synchronisation dans le cadre d'une synchronisation complète. Cette section n'est pas disponible quand vous utilisez le mode basique.
* vous avez la possibilité d'activer l'option **Nettoyage automatique des attributs non utilisés** sur ce panneau. Lorsqu'elle est activée, une fois par semaine le module cherchera et supprimera automatiquement tous les attributs qui ne sont plus utilisés par aucun produit (qu'il soit activé ou désactivé). Les groupes d'attributs concernés sont uniquement ceux qui sont utilisés dans le mapping des attributs de produit et celui des grilles de tailles.
* le magasin **fournisseur de prix** vous permet de sélectionner quel magasin fournira les prix qui seront présentés sur Internet. Il déterminera donc également la taxe qui doit s'appliquer (Taux de TVA) pour déterminer le prix HT de vos produits lorsque vos internautes commandent depuis un pays non soumis à la TVA.
* le **magasin de vente** quant à lui vous permet de désigner sur quel magasin sera passé la vente Internet dans votre backoffice.

#### Paramètres des commandes

Dans ce panneau, vous pouvez : 
* choisir si vous désirez exporter les clients et leurs informations nomminatives vers le backoffice LCV ;
* renseigner les références LCV (code barre) qui seront utilisés pour désigner les frais de port et les frais d'emballage dans les ventes exportés vers LCV dans les options **référence pour les frais de port** et **référence pour l'emballage** ;
* le **mapping des modes de règlements** vous permet de mapper les modes de règlement Prestashop avec ceux utilisés sous LCV. En face de chaque mode de règlement Prestashop qui vous est présenté, renseignez le code de règlement LCV à utiliser lors de l'exportation de la commande. Si aucun mode de règlement n'est précisé, c'est le catch-all (*) qui sera utilisé. Si le catch-all n'est pas non plus défini, alors la commande sera ignorée.

A des fins de sécurité, dans les options d'exportation des commandes, vous devez définir :
- **l'age maximal d'une commande** pour qu'elle (ou ses modifications) puisse être exportée sur votre backoffice LCV ;
- **l'ID minimal qu'elle doit avoir**, ce qui vous permet d'ignorer de manière sécurisée d'anciennes commandes. Toutes les commandes dont l'ID est inférieur ne sera pas considérée, ni exportée automatiquement. *Nous vous recommandons, au moins une fois par an, de venir ajuster ce paramètre pour vous prémunir de toute exportation massive de données suite à une erreur de manipulation ou bien d'édition de masse sur votre base de données qui résulterait d'un renvoi massif d'information.*

Si vous souhaitez exporter manuellement vous même les commandes sans que cela ne soit fait automatiquement par le module, vous pouvez renseigner un ID minimal bien supérieur au maximum actuel et utilisez le bouton `Exporter vers LCV` depuis la page de chaque commande quand vous désirez envoyer la commande sur votre backoffice.

Si l'option **Exporter les annulations, modifications, remboursements et retours** est désactivée, seules les commandes validées sont envoyées à votre backoffice. En l'activant, le module enverra également à LCV toutes les mises à jour d'une commande après son premier envoi.

### Mappages

Pour importer vos produits, un certain nombre de données ne peuvent pas être créées à la volée ou nécessite un carcan pour être crées et doivent donc être mappées, i.e. "transposée". Sans cette transposition, il serait impossible d'importer vos articles.

Cette opération vous permet par exemple d'assigner la bonne marque et la bonne catégorie à chaque produit en suivant des règles de transposition simples en définissant une matrice qui globalement, pour chaque donnée de votre backoffice LCV fait correspondre une donnée Prestashop à utiliser.

Voici une liste non exhaustive de données que vous pouvez mapper :

- les grilles de tailles qui doivent être transposées en groupe d'attributs Prestashop ;
- les marques qui doivent être transposées en marque Prestashop pré-existante ;
- les catégories & RFS qui doivent être transposées en une ou plusieurs catégories Prestashop pré-existantes ;

Tous les mappages fonctionnent de la même façon sur le module :

- si le mapping est défini pour une donnée précise, il est utilisée ;
- sinon un mapping dit ``wildcard (*)`` est utilisé (souvent appelé *Tou(te)s les autres*) ;
- une valeur spéciale vous permet d'ignorer les produits utilisant cette donnée à l'importation.

Vous pouvez définir vos mappings dans la page ``Mapping LCV`` de la section ``VENDRE \ Catalogue`` du backoffice Prestashop ; accessible également par le bouton ``Mappings`` de la page de configuration du module.

***Notes :***

*A de rares exceptions près, vous ne pouvez pas créer manuellement des mappings mais seulement les définir ; leur création intervient automatiquement lors de la synchronisation quand le module initie le dialogue avec votre backoffice. Ainsi, tant que vous n'avez pas réalisé au moins une synchronisation avec votre module, il est très probable que vous n'ayez rien dans les grilles de mappage.*

*Pour toutes les tables de correspondances, il se peut que votre module ne détecte pas toutes les catégories dynamiques utilisées sur votre backoffice LCV ou certains paramètres. Dans un tel cas, vous pouvez cliquer sur le bouton "Télécharger" présent dans le bandeau supérieur de toutes les pages de configuration. Une connexion sera établie avec le backoffice pour télécharger vos tables.*

#### Poids par défaut

Sur le mappage des catégories, vous pouvez spécifier une valeur de poids par défaut. Lors de l'importation d'un produit appartenant à cette catégorie, si le backoffice ne précise par de poids, le module affecte alors cette valeur au produit.
Si le produit appartient à des catégories différentes ayant chacune une valeur de poids par défaut différente, le module privilégie la valeur de poids la plus haute.

*A savoir* : il sera nécessaire d'attendre ou de déclencher une synchronisation pour appliquer vos modifications sur les produits. Cette synchronisation n'a pas besoin d'être totale.

#### Mappages périmés et nettoyage

Il arrive que des clés de mappage ne soient plus utilisées par aucun produit et parasitent l'interface. Il existe un utilitaire de nettoyage des mappages qui peut vous aider à retirer de la base tous les mappages qui n'ont pas été définis et qui ne sont plus utilisés par les produits.

Ce dernier est automatiquement démarré lors que vous téléchargez la configuration du backoffice à l'aide du bouton accessible dans la barre d'outils de la page de configuration du module.


## Synchronisation du catalogue produits

La synchronisation du catalogue produits est réalisée à intervalles réguliers par une tâche automatisée installée automatiquement par le module ou appelée manuellement par une intervention externe *(cf. Installation)* à condition d'avoir préalablement paramétré le module dans le mode "`Synchronisation du catalogue & du stock`".

Pour les produits déjà existants, un bouton de synchronisation est ajouté dans la barre d'outils des fiches produits compatibles (à côté du bouton d'aide). Ce bouton vous permet de resynchroniser que ce produit afin de refléter des modifications récentes ou bien de vérifier que la synchronisation fonctionne bien.

### Audit et journalisation

La synchronisation produit un fichier d'audit par jour stocké dans le répertoire /var/logs de Prestashop. Il contient la journalisation des actions du module et vous pouvez consulter ce journal dans les options du module.

### Informations synchronisées

Vous pouvez sélectionner les informations à synchroniser dans l'onglet "Catalogue" de la page de configuration du module : référence, nom du produit, marques, etc...

Une donnée qui est synchronisée est systématiquement écrasée par sa valeur du backoffice LCV lorsqu'elle existe et lorsque le module synchronise le produit. Dans le cas contraire, la donnée est simplement reportée à la création de la fiche produit sous Prestashop.

*🛈 Par sécurité, le module modifie la page d'édition des produits de Prestashop de sorte qu'il vous soit impossible de modifier par cet écran une donnée qui est maintenue à jour depuis votre backoffice, car celle-ci serait susceptible d'être remplacée vous faisant perdre vos modifications.* 

*Les champs gérés par le module sont grisés et de couleur orange, uniquement sur les produits créés et maintenus par le module.*

## Disponibilité des pièces dans les boutiques

Le module embarque 3 options pour rendre les stocks par magasin sur vos pages produits, afin que vos internautes puissent voir d'un coup d'oeil si le produit qu'ils sont en train de consulter est disponible dans les magasins proches de leur domicile.

Pour que cette option fonctionne, il faut préalablement avoir mappé vos magasins LCV avec vos magasins listés sous Prestashop par l'intermédiaire du mapping des magasins, disponible dans les options.

### Afficher la disponibilité sur les thèmes compatibles

La solution la plus simple est d'activer l'option "Afficher la disponibilité par magasin" disponible dans la configuration du module, sur la page "Paramètres du catalogue".

Vous pourrez régler des options de base telles que le seuil de quantités qui détermine si la pièce est disponible (vert) ou dans l'état "dernières pièces disponibles" (orange).

Le hook utilisé pour injecter la disponibilité est le hook `displayProductAdditionalInfo`. Si l'information n'apparaît pas à l'endroit souhaité ou après les informations d'un autre module, vous pouvez modifier l'ordre sous l'option `Personnaliser/positions` de Prestashop.

### Afficher la disponibilité par hook dans les templates

Si l'option précédente ne fonctionne pas, vous pouvez appeler le hook `hookDisplayStoreStocks` directement dans les sources du template de la page produit. Ce crochet permet de calculer et d'afficher un tableau habillable par CSS à l'aide d'une puce de couleur (vert, orange, rouge) en fonction de la disponibilité de la taille sélectionnée dans chaque magasin. 

### Calculer la disponibilité par hook dans les templates

Si le rendu de l'option précédente ne vous plait pas, vous pouvez appeler le hook `hookBuildStoreStocks` directement dans les sources du template de la page produit. Ce crochet permet de charger les informations de disponibilité. Ensuite, vous pouvez calculer le rendu de votre choix en vous basant sur la nouvelle donnée `stores_stocks` qui a été peuplée pendant l'appel.

## Questions fréquentes

### J'ai fait ma première synchronisation et aucun produit n'a été créé ?

Si vous avez effectué votre première synchronisation et que vous n'avez aucun produit créé sur Prestashop :

- Vérifiez que vous êtes bien en mode `complet`. En effet, si vous êtes resté en mode basique, le module ne créera aucune fiche produit.
- Vérifiez également que vos mappings de marque et grille de tailles sont correctement défini. Par défaut, le module est réglé pour ignorer les produits de toutes les marques et de toutes les grilles de tailles, soit tous les produits.
- Enfin, si tout est correct, vous pouvez regarder le journal d'audit des synchronisations, la raison y sera généralement indiquée de manière lisible.

### Je viens de corriger mes mappings, pourtant après synchronisation, mes produits ne s'importent toujours pas ou n'ont pas été déplacés en conséquence ?

Certains mappings nécessite d'être synchronisés depuis le backoffice LCV ; hors la synchronisation est incrémentielle et ne prend en compte que les produits qui ont été créés ou modifiés depuis la dernière synchronisation.

La solution est donc de tout resynchroniser pour forcer le module à tout reprendre depuis le départ.

### Comment tout resynchroniser ?

Par défaut, le module ne resynchronise que les données ayant changé sur votre backoffice depuis la dernière synchronisation.

Vous pouvez toutefois indiquer au module de tout resynchroniser (tout le catalogue, les stocks et les prix) en cliquant sur le bouton "`Resynchroniser`" de la page de configuration du module.

La resynchronisation totale sera effectuée lors de la prochaine synchronisation programmée.

### La synchronisation ne semble pas fonctionner.

Avant toute chose, vous devez consulter le journal de Prestashop. Si celui-ci contient des erreurs à propos de la synchronisation, la raison en sera clairement indiquée.

Résolvez ces problèmes en premier lieu.

Si les problèmes n'ont pas été trouvés ou résolus, n'hésitez pas à consulter le journal d'audit du module. Il contient toutes les actions du module, ce qui pourra vous renseignez sur une probable cause. Les raisons les plus fréquentes de non synchronisation sont :

- la tâche CRON n'est pas appelée (dans ce cas, le journal d'audit est souvent vide) ou retourne une erreur ;
- un mode de règlement, des frais de port ou d'emballage non défini dans la configuration ;
- une marque, une catégorie ou une grille de tailles non mappée ou interdite ;
- le mode de synchronisation mal défini ou mis sur pause ;

### Empêcher une fiche produit d'être synchronisée

Lorsque le module est paramétré pour synchroniser les fiches produits, une icône de verrouillage vous permet d'empêcher le module de modifier la fiche produit. Si l'icône est un cadenas rouge, alors le module ignorera cette fiche produit et se contentera d'en synchroniser que les prix et les stocks.

Pour changer le comportement pour cette fiche produit, cliquez sur l'icône pour verrouiller ou déverrouiller la fiche.

Notez que le verrouillage vous permet de libérer tous les champs en édition.

### Resynchroniser une fiche produit.

Lorsque le module est paramétré pour synchroniser les fiches produits, une icône de synchronisation apparaît sur sa fiche produit vous permettant de déclencher une resynchronisation de ce produit.

La synchronisation du produit ne concerne que ses propriétés et non son stock ou ses promotions. Si le stock ou les promotions de ce produit n'est pas à jour, merci de bien vouloir procéder à une synchronisation complète ou attendre qu'elle se déclenche.

Cliquez sur l'icône pour déclencher la synchronisation de la fiche.

### Exporter ou réexporter une commande manuellement

Les commandes ne se réexportent jamais lors que le système ne détecte pas d'erreur. 
Aussi, trois cas peuvent vous intéresser :

**Cas n°1 : erreur d'exportation**

Il y a eu une erreur lors de l'exportation de la commande ou de sa modification, et votre commande s'est vue affublée de l'état `Erreur d'exportation LCV` après avoir éventuellement corrigé le problème.

N'hésitez pas à consulter le journal d'audit pour connaître la raison du problème d'exportation de cette commande.

Pour déclencher une nouvelle tentative d'exportation de la commande, vous devez simplement lui affecter un autre état et elle sera programmée pour être exportée lors de la prochaine synchronisation ou bien appuyer sur le bouton `Réexporter vers LCV` pour tenter de le faire immédiatement. 

**Cas n°2 : perte au niveau du backoffice LCV**

Vous avez perdu la commande sur votre backoffice LCV suite à un retour en arrière, un désastre ou un incident d'exploitation.
Malheureusement, ce cas n'est pas solutionnable avec le module. Vous devez malheureusement resaisir les commandes perdues manuellement.

**Cas n°3 : la commande ne s'exporte pas automatiquement**

La commande pourtant validée et payée n'a ni l'état `Exportée vers LCV`, ni l'état `Erreur d'exportation LCV`.

Vérifiez le journal d'audit pour en connaître la cause et la corriger mais en général, il s'agit d'une de celle-ci :
- la commande est trop agée (plus de 90 jours) ;
- un des modes de règlements n'est pas mappé ;
- il n'y a pas d'article à livrer dans la commande (tous remboursés) ;
- le statut n'est pas un statut de commande valide (payée, facturée et livrable) ;
- le montant payé ne correspond pas au total de la commande ;

### Gérer les remboursements 

Quand vous remboursez partiellement une commande (dans le cadre d'un retour par exemple), vous devez passer par le bouton `Remboursement` de Prestashop et cocher la case `générer un avoir`, même si vous prévoyez de recréditer la carte bancaire. Sous Prestashop, un avoir est un document qui atteste fiscalement de l'annulation d'une partie ou de la totalité de la facture précédemment émise, et non un bon utilisable pour payer une autre commande. Ensuite, vous pouvez décider de recréditer la carte ou bien générer un bon de réduction.

Si un avoir a été généré, le remboursement de la commande sera exporté vers votre backoffice LCV sous forme de remboursement. Si vous marquez votre commande comme annulée, remboursée ou tout autre état de commande non valide, ou si vous ne générez pas d'avoir pour cette modification, le module annulera l'intégralité du précédent débit exporté vers LCV pour le resaisir dans sa version modifiée (ou ne pas le resaisir s'il s'agit d'une annulation complète).

Si un bon de réduction a été émis sous Prestashop, il sera importé comme une remise négative sous LCV.

### Pourquoi un de mes comptes client Prestashop n'est pas exporté vers LCV ?

Le module est prévu pour envoyer sur LCV uniquement les clients ayant effectué au moins un achat, qui ne s'avère pas être un client marketplace (Amazon, Spartoo, ...) ou bien si ce client appartient bien à un groupe nommé `Clients LCV`. Si le compte de votre client ne remonte pas sur le backoffice, c'est probablement que vous n'êtes pas dans un de ces cas.

Puisque le client n'est pas exporté vers le backoffice, toutes modifications opérées sur ce client ne remonte pas non plus.

### Reprise d'un site existant

Pour mettre en place la synchronisation des produits et/ou des stocks & prix, il est nécessaire d'établir la correspondance entre vos articles sous Prestashop et vos références sous votre backoffice. 

**Procéder absolument par étape :**

- En premier, configurez le module en mode basique pour prévenir toute suppression de données involontaire ;
- Ensuite, vérifiez votre mappage de produit ;
- Une fois que le mappage de produit est réalisé, vous pouvez éventuellement configurer le module en mode complet pour prendre en charge la gestion des fiches produits ;

Pour mapper vos produits, dans le *mapping des produits* disponible dans la page de configuration du module, faites correspondre à chaque ligne de produit Prestashop la référence backoffice EAN pour ce même article. 

La case *LOCK*, cochée par défaut, vous permet de verrouiller la fiche produit en l'état pour empêcher le module de remplacer les données de cette fiche produit par celle du backoffice dans le cadre du fonctionnement en mode complet. Si cette case est décochée, la fiche devient alors administrée par le module et vous pouvez potentiellement perdre tout ou partie des informations rentrées manuellement sur cette fiche. Quand cette case est cochée, seuls les prix, les promos et les stocks sont entretenus.

Nous vous conseillons vivement de ne pas la décocher à moins de savoir **exactement** ce que vous faîtes et ce que vous voulez obtenir ; et de faire une sauvegarde de vos données avant.

### Site de préproduction

Vous pouvez raccorder vos sites de préproduction au backoffice LCV avec la clé pour tester d'éventuelles modifications du site Internet sans que cela pose problème.

Pour éviter de nécessiter une deuxième clé d'accès, initialisez votre base de données de préproduction à partir d'une copie de la base Prestashop de production. Elle contient l'empreinte de la clé d'accès vers le backoffice et héritera donc des mêmes données.

**Dans tous les cas, n'oubliez pas d'ajuster le paramètre** `ID minimal d'exportation` des options d'exportation de commandes pour y mettre une valeur démesurément grande *(par exemple : 1000000)* pour éviter toute exportation de commande de tests sur le backoffice LCV.
