<?php
namespace PrestaShop\Module\LCVPrestaConnector;

use LCVPrestaConnector;

class Upgrade_8_0_6 {    
    /**
     * Déclenche la mise à jour de la base de données du module
     */
    public function upgrade(LCVPrestaConnector $module, $db)
    {          
          // On créer une table pour gérer les envois de commandes
          if (!$db->execute('
               CREATE TABLE IF NOT EXISTS `' . $module->TblPrefix . 'orders_updates` (
                    `id_order` INT(10) UNSIGNED NOT NULL,
                    `revision` INT(10) UNSIGNED NOT NULL DEFAULT 0,
                    `snapshot` LONGTEXT NOT NULL,
                    `pushed` LONGTEXT NOT NULL,
                    `done` DATETIME,
                    PRIMARY KEY (`id_order`)
               ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;'))
               throw new \Exception('Erreur lors de la création de la table de mappage des stocks');

          // On lie le champ `id_order` à la table des commandes
          if (!$db->execute('
               ALTER TABLE `' . $module->TblPrefix . 'orders_updates`
               ADD FOREIGN KEY (`id_order`) REFERENCES `' . _DB_PREFIX_ . 'orders`(`id_order`)
               ON UPDATE CASCADE ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère vers la table des commandes');          
    }
}